﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="System.Collections.Generic" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Core" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
	<head>
		<title>Deklaracja RP-7</title>
		<script runat="server">		

            public enum WgParametr {
                WgDatyWypłaty,
                WgOkresuListyPłac,
                [Caption("Wg miesiąca ZUS")]
                WgMiesiącaZUS,
                WgOkresuElementu
            }  
              
	//Odchyłki na plus dla elementów o stałej wartości wykazuj jako elementy o zminnej wartości    
    static bool odchyłkiPlusJakoZmienne = false;
		    
    public class Params: ContextBase {
    
            public Params(Context context): base(context) {
                okres = FromTo.All;
            }
    
            FromTo okres;
            [Required]
            [Caption("Raport za okres:")]
            public FromTo Okres {
                get { return okres; }
                set {
                    okres = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }
    
        Params pars;
        [Context]
        public Params Pars {
            get { return pars; }
            set { pars = value; }
        }

        public class SrParams : SerializableContextBase {
            public SrParams(Context context) : base(context) {
            }

            bool pelneStanowisko = false;
            [Priority(1)]
            [Caption("Stanowisko pełna nazwa")]
            public bool PelneStanowisko {
                get { return pelneStanowisko; }
                set {
                    pelneStanowisko = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            bool sumyBezLimitu = false;
            [Priority(2)]
            [Caption("Sumy bez lim.podst.E/R")]
            public bool SumyBezLimitu {
                get { return sumyBezLimitu; }
                set {
                    sumyBezLimitu = value;
                    if (sumyBezLimitu)
                        uwzględnijSwiadczenia = false; 
                    OnChanged(EventArgs.Empty);
                }
            }
            
            bool uwzględnijSwiadczenia = true;
            [Priority(3)]
            [Caption("Uwzględnij świadczenia")]
            public bool UwzględnijSwiadczenia {
                get { return uwzględnijSwiadczenia; }
                set {
                    uwzględnijSwiadczenia = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            public bool IsReadOnlyUwzględnijSwiadczenia() {
                return sumyBezLimitu;
            }

            bool pokażLimit = false;
            [Priority(4)]
            [Caption("Pokaż limit")]
            public bool PokażLimit {
                get { return pokażLimit; }
                set {
                    pokażLimit = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            bool uzupełnijRodzaj = false;
            [Priority(5)]
            [Caption("Uzupełnij rodzaj")]
            public bool UzupełnijRodzaj {
                get { return uzupełnijRodzaj; }
                set {
                    uzupełnijRodzaj = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            WgParametr wgParam = WgParametr.WgOkresuListyPłac;
            [Priority(6)]
            [Caption("Wynagrodzenie")]
            public WgParametr WgParam {
                get { return wgParam; }
                set {
                    wgParam = value;
                    OnChanged(EventArgs.Empty);
                }
            }
        }

        SrParams srpars;
        [SettingsContext]
        public SrParams SrPars {
            get { return srpars; }
            set { srpars = value; }
        }		
            
        class Total {
            decimal[] sumyDoLimitu = new decimal[5];
            decimal[] sumyPonadLimit = new decimal[5];
            Hashtable[] definicje = new Hashtable[5];
            readonly int rok;
            readonly SrParams srpars;
            public YearMonth przekroczenie = YearMonth.MaxValue;
            public Total(int rok, SrParams srpars) {
                this.rok = rok;
                this.srpars = srpars;
                for (int i=0; i<5; i++)
                    definicje[i] = new Hashtable();
            }
            public void Add(WypElement element) {
                PozycjaRP7 pozycja = element.Definicja.Deklaracje.PozycjaRP7;
                if (pozycja!=PozycjaRP7.NieDotyczy) {
                    if (element is WypElementUmowa && element.Podatki.Wypadkowa.Firma==0)
                        return;

                    decimal do_limitu;
                    decimal ponad_limit;
                    
                    //TID: 6286
                    /*if (pozycja == PozycjaRP7.ŚwiadczeniaZUbezpieczenia)
                        do_limitu = element.Wartosc;
                    else
                        do_limitu = element.Podatki.Emerytalna.Podstawa;
                    ponad_limit = element.Wartosc - do_limitu;*/

                    if (pozycja == PozycjaRP7.ŚwiadczeniaZUbezpieczenia)
                        ponad_limit = 0;
                    else
                        ponad_limit = element.Podatki.Wypadkowa.Podstawa - element.Podatki.Emerytalna.Podstawa;
                    if (ponad_limit != 0 && przekroczenie > element.MiesiacDeklaracji)
                        przekroczenie = element.MiesiacDeklaracji;
                        
                    do_limitu = element.Wartosc - ponad_limit;

                    decimal odchyłkiPlus = 0;
                    if (pozycja==PozycjaRP7.SkładnikiStałe && odchyłkiPlusJakoZmienne)
                        foreach (WypSkladnik skl in element.Skladniki)
                            if (skl.Rodzaj==RodzajSkładnikaWypłaty.OdchyłkaPlus)
                                odchyłkiPlus += skl.Wartosc;
                    decimal wartość = element.Wartosc - odchyłkiPlus;

                    Zapisz(element, pozycja, wartość, ref do_limitu, ref ponad_limit);
                    Zapisz(element, PozycjaRP7.SkładnikiZmienne, odchyłkiPlus, ref do_limitu, ref ponad_limit);
                }
            }
            void Zapisz(WypElement element, PozycjaRP7 pozycja, decimal wartość, ref decimal do_limitu, ref decimal ponad_limit) {
                int n = (int)pozycja - 1;
                bool rodzaj = wartość != 0;
                if (wartość <= do_limitu) {
                    sumyDoLimitu[n] += wartość;
                    do_limitu -= wartość;
                    wartość = 0;
                }
                else {
                    sumyDoLimitu[n] += do_limitu;
                    wartość -= do_limitu;
                    do_limitu = 0;
                }
                if (wartość <= ponad_limit) {
                    sumyPonadLimit[n] += wartość;
                    ponad_limit -= wartość;
                    wartość = 0;
                }
                else {
                    sumyPonadLimit[n] += ponad_limit;
                    wartość -= ponad_limit;
                    ponad_limit = 0;
                }
                if (definicje[n][element.Definicja] == null && rodzaj)
                    definicje[n].Add(element.Definicja, element.Definicja.Skrot);
            }
            public int Rok {
                get { return rok; }
            }
            public decimal Stałe {
                get { return Dodaj(sumyDoLimitu[0], sumyPonadLimit[0], srpars.SumyBezLimitu); }
            }
            public decimal Zmienne {
                get { return Dodaj(sumyDoLimitu[1], sumyPonadLimit[1], srpars.SumyBezLimitu); }
            }
            public string ZmienneOpis {
                get { return ToStr(definicje[1].Values); }
            }
            public decimal Inne {
                get { return Dodaj(sumyDoLimitu[2], sumyPonadLimit[2], srpars.SumyBezLimitu); }
            }
            public string InneOpis {
                get { return ToStr(definicje[2].Values); }
            }
            public decimal WNaturze {
                get { return Dodaj(sumyDoLimitu[3], sumyPonadLimit[3], srpars.SumyBezLimitu); }
            }
            public string WNaturzeOpis {
                get { return ToStr(definicje[3].Values); }
            }
            public decimal Świadczenia {
                get { return Dodaj(sumyDoLimitu[4], sumyPonadLimit[4], srpars.SumyBezLimitu); }
            }
            public decimal PonadLimit {
                get { return Suma(sumyPonadLimit); }
            }
            public decimal Razem {
                get {
                    decimal a = Suma(sumyDoLimitu) - sumyDoLimitu[4];
                    decimal b = Suma(sumyPonadLimit) - sumyPonadLimit[4];
                    if (srpars.UwzględnijSwiadczenia)
                        b += Świadczenia;
                    return Dodaj(a, b, !srpars.SumyBezLimitu);
                }
            }
            string ToStr(IEnumerable lista) {
                string ss = "";
                //Wg ZUS pola rodzaj się nie uzupełnia
                if (srpars.UzupełnijRodzaj) //TID: 8385, ale jednak czasem się wypełnia
                    foreach (string s in lista)
                        if (ss == "")
                            ss = s;
                        else
                            ss += ", " + s;
                return ss;
            }

            decimal Suma(decimal[] lista) {
                decimal v = 0;
                foreach (decimal d in lista)
                    v += d;
                return v;
            }
            decimal Dodaj(decimal a, decimal b, bool dodaj) {
                return dodaj ? a + b : a;
            }
        }

        public class NieobecInfo {

            readonly FromTo okres;
            readonly string nazwa;
            readonly string kategoria;
            
            public NieobecInfo(string nazwa, FromTo okres, string kategoria) {
                this.nazwa = nazwa;
                this.okres = okres;
                this.kategoria = kategoria;
            }

            public FromTo Okres { get { return okres; } }
            public string Nazwa { get { return nazwa; } }
            public string Kategoria { get { return kategoria; } }
        }

        public class NieobecInfoComparer : IComparer<NieobecInfo> {
            
            public int Compare(NieobecInfo x, NieobecInfo y) {
                int i = string.Compare(x.Kategoria, y.Kategoria);
                if (i == 0)
                    i = x.Okres.From.CompareTo(y.Okres.From);
                return i;
            }
        }

        void OnContextLoad(Object sender, EventArgs args) {
            report = ReportHeader1;
            PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];
            Pracownik pracownik = ph.Pracownik;
            PlaceModule płace = PlaceModule.GetInstance(pracownik);

            CoreModule core = CoreModule.GetInstance(dc);
            string nip = core.Config.Firma.Pieczątka.NIP;
            string regon = core.Config.Firma.Pieczątka.REGON;
            if (ph.Etat.Wydzial != null) {
                OddzialFirmy of = ph.Etat.Wydzial.Oddzial;
                while (of != null) {
                    bool on = !string.IsNullOrEmpty(of.Deklaracje.NIP);
                    bool or = !string.IsNullOrEmpty(of.Deklaracje.REGON);
                    if (on) nip = of.Deklaracje.NIP;
                    if (or) regon = of.Deklaracje.REGON;
                    if (on || or) break;
                    of = of.Nadrzedny;
                }
            }
            colNIP.EditValue = nip;
            colREGON.EditValue = regon;
            
            SubTable st = null;
            switch (srpars.WgParam) {
                case WgParametr.WgMiesiącaZUS:
                    st = new SubTable(płace.WypElementy.WgMiesiacZUS[pracownik], pars.Okres);
                    break;
                case WgParametr.WgDatyWypłaty:
                    st = new SubTable(płace.WypElementy.WgDaty[pracownik], pars.Okres);
                    break;
                case WgParametr.WgOkresuListyPłac:
                    st = new SubTable(płace.WypElementy.WgOkresuListy[pracownik], pars.Okres);
                    break;
                case WgParametr.WgOkresuElementu:
                    st = new SubTable(płace.WypElementy.WgPracownik[pracownik], pars.Okres);
                    break;
            }
            
            int f = 0;
            int t = 0;
            foreach (WypElement element in st) {
                try {
                    int v = 0;
                    switch (srpars.WgParam) {
                        case WgParametr.WgMiesiącaZUS:
                            v = element.MiesiacZUS.Year;
                            break;
                        case WgParametr.WgDatyWypłaty:
                            v = element.Data.Year; 
                            break;
                        case WgParametr.WgOkresuListyPłac:
                            v = element.OkresListy.To.Year;
                            break;
                        case WgParametr.WgOkresuElementu:
                            v = element.Okres.To.Year;
                            break;
                    }
                    if (f == 0)
                        f = v;
                    t = v;
                }
                catch { Msg(); }
            }

            if (pars.Okres.From != Date.MinValue && pars.Okres.From.Year < f)
                f = pars.Okres.From.Year;

            if (pars.Okres.To != Date.MaxValue && t < pars.Okres.To.Year)
                t = pars.Okres.To.Year;

            int n = t - f + 1;
            int m = n >= 10 ? n : 10;
            Total[] totals = new Total[m];
            for (int i = 0; i < m; i++)
                totals[i] = new Total(i < n ? f + i : 0, srpars);

            foreach (WypElement element in st) {
                try {
                    int v = 0;
                    switch (srpars.WgParam) {
                        case WgParametr.WgMiesiącaZUS:
                            v = element.MiesiacZUS.Year;
                            break;
                        case WgParametr.WgDatyWypłaty:
                            v = element.Data.Year;
                            break;
                        case WgParametr.WgOkresuListyPłac:
                            v = element.OkresListy.To.Year;
                            break;
                        case WgParametr.WgOkresuElementu:
                            v = element.Okres.To.Year;
                            break;
                    }
                    totals[v - f].Add(element);
                }
                catch { Msg(); }
            }

            Grid1.DataSource = totals;

            ReportHeader2["PŁEĆ"] = ph.Plec == PłećOsoby.Kobieta ? "Pani" : "Pan";
            labelStanowisko.EditValue = GetStanowisko(ph);

            List<NieobecInfo> lst = new List<NieobecInfo>();
            foreach (OkresNieobecności on in pracownik.Czasy.Nieobecnosci(pars.Okres, true)) {
                KodRSA rsa = on.Definicja.KodRSA;
                if (rsa != null) {
                    string kategoria;
                    switch (rsa.Kod) {
                        case 111:
                        case 112:
                        case 350:
                            if (rsa.Kod==350 && on.Definicja.Guid!=new Guid("00000000-0006-0005-0019-000000000000"))
                                continue;
                            kategoria = "Urlopy bezpłatne"; break;
                        case 121:
                        case 122:
                        case 311:
                        case 319:
                        case 325:
                            if (rsa.Kod==311 && on.Definicja.Guid!=new Guid("00000000-0006-0005-0040-000000000000"))
                                continue;
                            if (rsa.Kod==319 && on.Definicja.Guid!=new Guid("00000000-0006-0005-0045-000000000000"))
                                continue;
                            if (rsa.Kod==325 && on.Definicja.Guid!=new Guid("00000000-0006-0005-0044-000000000000"))
                                continue;
                            kategoria = "Urlopy wychowawcze"; break;
                        default:
                            continue;
                    }
                    lst.Add(new NieobecInfo(on.Definicja.Nazwa.Replace(", hist.", ""), on.Okres, kategoria));
                }
            }

            foreach (WypElement e in st) {
                try {
                    KodRSA rsa = e.KodRSA;
                    if (rsa != null) {
                        string kategoria;
                        switch (rsa.Kod) {
                            case 311:
                            case 319:
                            case 325:
                            case 327:
                                kategoria = "Zasiłki macierzyńskie"; break;
                            case 312:
                                kategoria = "Zasiłki opiekuńcze"; break;
                            case 313:
                            case 314:
                                kategoria = "Zasiłki chorobowe"; break;
                            case 321:
                            case 322:
                                kategoria = "Świadczenia rehabilitacyjne"; break;
                            case 330:
                            case 331:
                            case 332:
                            case 333:
                            case 334:
                                kategoria = "Wynagrodzenia chorobowe"; break;
                            default:
                                continue;
                        }
                        lst.Add(new NieobecInfo(e.Nazwa, e.Okres, kategoria));
                    }
                }
                catch { Msg(); }
            }

            /*
                Nieobecności
                 121,122 - urlop wychowawczy
                 111,112 - urlop bezpłatny
             * Elementy
                311, 327 - zasiłek macierzyński
                312 - zasiłek opiekuńczy
                313, 314 - zasiłek Chorobowy
                321, 322 - Świadczenie rehabilitacyjne
                330...334 - wynagrodzenie chorobowe
              */

            lst.Sort(new NieobecInfoComparer());

            Grid2.DataSource = lst;
        }
        
        string GetStanowisko(PracHistoria ph) {
            string stanowiskoPelne = "";
            if (srpars.PelneStanowisko)
                stanowiskoPelne = ph.Etat.StanowiskoPełne;
            if (stanowiskoPelne.Length == 0)
                stanowiskoPelne = ph.Etat.Stanowisko;
            return stanowiskoPelne;
        }
    
            protected void Grid1_BeforeRow(object sender, RowEventArgs args) {
                Total total = (Total)args.Row;

                //Skladniki stałe
                colStałe.AddLine(total.Stałe.ToString("n"));
                if (total.przekroczenie != YearMonth.MaxValue && srpars.PokażLimit) {
                    PlaceModule płace = PlaceModule.GetInstance(dc);
                    decimal limit = płace.Config.SkładkiZUS.MaksymalnaRocznaPodstawa[total.przekroczenie.LastDay];
                    colStałe.AddLine("Limit:");
                    colStałe.AddLine(limit.ToString("0.00"));
                    colStałe.AddLine(total.przekroczenie.ToString("MMMM", System.Globalization.CultureInfo.CurrentCulture));
                    
                    colInne.AddLine(0m);
                    colInneOpis.AddLine("&nbsp;");
                }                                 
                
                //Składniki zmienne
                //Składniki inne
                if (total.PonadLimit != 0) {
                    colInne.AddLine(total.PonadLimit);
                    colInneOpis.AddLine("ubezp.wypad.");                    
                }
                colInne.AddLine(total.Inne);
                colInneOpis.AddLine(total.InneOpis=="" ? "&nbsp;" : total.InneOpis);
        }

        public static ReportHeader report;

        public static void Msg() {
            string msg = "Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
            if (report != null && !report.Title.Contains(msg))
                report.Title += "|" + msg;
        }

</script>
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="DeklaracjaRP7" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Kadry.PracHistoria,Soneta.KadryPlace"></ea:datacontext>
			<cc1:reportheader id="ReportHeader1" NagłówekOddziału="NagłówekOddziału" title="ZAŚWIADCZENIE O ZATRUDNIENIU I WYNAGRODZENIU" runat="server"></cc1:reportheader>
			<p>
				<font size="2">Pieczątka pracodawcy - płatnika składek</font>
			</p>
			<p>
				<table id="Table1" cellspacing="0" width="100%">
					<tbody>
						<tr>
							<td width="10%">
								<font size="2"></font>
							</td>
							<td width="40%">
								<p>
									<font size="2">1. NIP </font>
									<ea:DataLabel id="colNIP" runat="server"></ea:DataLabel>
								</p>
							</td>
							<td>
								<font size="2">2. REGON </font>
								<ea:DataLabel id="colREGON" runat="server"></ea:DataLabel>
							</td>
						</tr>
						<tr>
							<td style="WIDTH: 83px; HEIGHT: 16px">
								<font size="2"></font>
							</td>
							<td style="HEIGHT: 16px" align="center" colspan="2">
								<font size="2">Jeżeli płatnikowi nie nadano nr wym. w pkt 1 i 2, należy podać:</font></td>
						</tr>
						<tr>
							<td style="WIDTH: 83px">
								<font size="2"></font>
							</td>
							<td valign="top">
								<p>
									<font size="2">3.&nbsp;Nr PESEL&nbsp;<br />
                                        . . . . . . . . . .&nbsp;. . . . . . . . . 
										.&nbsp;. . . . . . . . . .</font>
								</p>
							</td>
							<td>
								<p>
									<font size="2">lub 4. Numer i serię dowodu osobistego lub paszportu<br/>
										&nbsp;. . . . . . . . . .&nbsp;. . . . . . . . . .&nbsp;. . . . . . . . . 
										.&nbsp;. . . . . . . . . .<br/>
										&nbsp;</font>
								</p>
							</td>
						</tr>
					</tbody>
				</table>
			</p>
			<p>
				<font size="2"></font>
			</p>
			<p>
				<font size="2">-------------------------------------------------------------------------------------------------------------------------</font><br />
                <font size="2"><b>Uwaga!</b> W zaświadczeniu należy obligatoryjnie wypełnić każdy punkt poprzez wpisanie danych lub stwierdzenia np.: „tak”, „nie”, „nie pobierał”, „nie dotyczy”.</font>
			</p>
			<ol>
				<li>
					<font size="2">Pan (Pani) </font>
					<ea:DataLabel id="DataLabel3" runat="server" DataMember="Pracownik.NazwiskoImię"></ea:DataLabel>
					<font size="2">, </font>
					<ea:DataLabel id="DataLabel4" runat="server" DataMember="NazwiskoRodowe"></ea:DataLabel>
					<font size="2">&nbsp;ur. </font>
					<ea:DataLabel id="DataLabel5" runat="server" DataMember="Urodzony.Data"></ea:DataLabel>
					<font size="2">&nbsp;(numer PESEL) </font>
					<ea:DataLabel id="DataLabel6" runat="server" DataMember="PESEL"></ea:DataLabel>
					<font size="2">&nbsp;<span style="vertical-align: super">(1)</span> był(a) - jest* zatrudniony(a) w okresie od&nbsp; </font>
					<ea:DataLabel id="DataLabel7" runat="server" DataMember="Etat.OkresZatrudnienia.From"></ea:DataLabel>
					<font size="2">&nbsp;do </font>
					<ea:DataLabel id="DataLabel8" runat="server" DataMember="Etat.OkresZatrudnienia.To">
						<ValuesMap>
							<ea:ValuesPair Key="(max)" Value="&lt;/strong&gt;. . . . . . . . . . . . . . .&lt;strong&gt;"></ea:ValuesPair>
						</ValuesMap>
					</ea:DataLabel>
					<font size="2">ostatnio </font>
					<ea:DataLabel id="labelStanowisko" runat="server"></ea:DataLabel>
					<font size="2">. </font>
				</li>
				<li>
					<font size="2">W okresie trwania stosunku pracy Pan(i) </font>
					<ea:DataLabel id="DataLabel10" runat="server" DataMember="Pracownik.NazwiskoImię"></ea:DataLabel>
				</li>
                <ol>
				<li style="LIST-STYLE-TYPE: lower-alpha">
					<font size="2">pobierał(a) wynagrodzenie za pracę do . . . . . . . . . . . . . . . 
						. . . . .; wynagrodzenie za czas niezdolności do pracy* od . . . . . . . . . . 
						. . . . . . . . . . do . . . . . . . . . . . . . . . . . . . . <span style="vertical-align: super">
                            (3)</span>; zasiłek 
						chorobowy po dniu 14.11.1991 r. od . . . . . . . . . . . . . . . . . . . . do . 
						. . . . . . . . . . . . . . . . . . . oraz zasiłek chorobowy wyczerpie z dniem 
						. . . . . . . . . . . . . . . . . . . . <span style="vertical-align: super">
                            (4)</span>; zasiłek opiekuńczy od . . . . . . 
						. . . . . . . . . . . . . . do . . . . . . . . . . . . . . . . . . . . <span style="vertical-align: super">(4)</span>;
						świadczenie rehabilitacyjne od . . . . . . . . . . . . . . . . . . . . do. . . 
						. . . . . . .&nbsp;. . . . . . . . . .&nbsp; *; wynagrodzenie za czas 
						niezdolności do pracy oraz zasiłki po dniu 14.11.1991 r. pobrał(a) także w 
						okresach podanych w załączonym wykazie *; </font>
				</li>
				<li style="LIST-STYLE-TYPE: lower-alpha">
					<font size="2">przebywał(a) na urlopie bezpłatnym udzielonym w związku . . . . . . 
						. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
						. . . . w okresie od . . . . . . . . . . do . . . . . . . . . ., od . . . . . . 
						. . . . do . . . . . . . . . ., od . . . . . . . . . . do . . . . . . . . . .;<br/>
						urlopie wychowawczym * w okresie od . . . . . . . . . . do . . . . . . . . . ., 
						- . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
						. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
						. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
						. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
						. . . . . . . . . . . . . . . . . . . 
                        inne okresy za które nie wypłacono wynagrodzenia lub zasiłku chorobowego, z wyjątkiem pierwszego dnia niezdolności do pracy</font>
				</li>
                </ol>
			<li>
				<font size="2">
					Wynagrodzenie - przychód (dochód) - uposażenie* - w okresach wybranych przez 
					pracownika wynosił(o): </font>
				<p>
					<ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow">
						<Columns>
							<ea:GridColumn ID="GridColumn1" Width="7" Align="Center" DataMember="Rok" Caption="Rok kalenda-rzowy" HideZero="True" runat="server"></ea:GridColumn>
							<ea:GridColumn Align="Right" 
                                Caption="Wynagrodzenie - przych&#243;d (doch&#243;d) - uposażenie *~składniki stałe zł" 
                                runat="server" ID="colStałe"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn2" Align="Right" DataMember="Zmienne" Caption="Wynagrodzenie - przych&#243;d (doch&#243;d) - uposażenie *~składniki zmienne kwota zł"
								HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn3" Align="Center" DataMember="ZmienneOpis" Caption="Wynagrodzenie - przych&#243;d (doch&#243;d) - uposażenie *~składniki zmienne rodzaj" runat="server"></ea:GridColumn>
							<ea:GridColumn Align="Right" Caption="Wynagrodzenie - przych&#243;d (doch&#243;d) - uposażenie *~inne kwota zł"
								HideZero="True" Format="{0:n}" ID="colInne" runat="server" VAlign="Top"></ea:GridColumn>
							<ea:GridColumn Align="Center" 
                                Caption="Wynagrodzenie - przych&#243;d (doch&#243;d) - uposażenie *~inne rodzaj" 
                                ID="colInneOpis" runat="server" VAlign="Top"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn4" Width="10" Align="Right" DataMember="WNaturze" Caption="Wynagrodzenie - przych&#243;d (doch&#243;d) - uposażenie *~świadczenia w naturze kwota zł"
								HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn5" Width="10" Align="Center" DataMember="WNaturzeOpis" Caption="Wynagrodzenie - przych&#243;d (doch&#243;d) - uposażenie *~świadczenia w naturze rodzaj" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn6" Width="13" Align="Right" DataMember="Świadczenia" Total="Info" Caption="Wynagrodzenie za czas niezdolności do pracy - świadczenia z ubezpieczenia społecznego wypłacone zamiast wynagrodzenia - przychodu"
								HideZero="True" Format="{0:n}" runat="server"></ea:GridColumn>
							<ea:GridColumn ID="GridColumn7" Width="13" Align="Right" DataMember="Razem" Total="Sum" Caption="Łączna kwota wynagrodzenia - przychodu - świadczeń pieniężnych - uposażenia"
								Format="{0:n}" runat="server"></ea:GridColumn>
						</Columns>
					</ea:Grid>
                    <span style="font-size: 10pt">Zasady wykazywania wynagrodzenia – przychodu (dochodu)
                        zamieszczone są na stronie drugiej w „Informacji”.</span></p>
            </li>
            </ol>
            <p><span style="font-size: 10pt"><strong>ZUS Rp-7</strong></span></p>
			<ea:PageBreak id="PageBreak1" runat="server"></ea:PageBreak>
			<ol start="4">
			<li>
					<font size="2">Pracodawca - do 31.12.1998 r. zgłaszał pracowników do ubezpieczenia 
						społecznego w deklaracji rozliczeniowej bezimiennej - deklaracji imiennej* pod 
						numerem konta (NKP) . . . . . . . . . . . . . . . . . . . . w Oddziale ZUS w . 
						. . . . . . . . . . . . . . . . . . . </font>
            </li>
			<li>
					<font size="2">Zaświadczenie niniejsze zostało wystawione na podstawie 
						następujących dokumentów:. . . . . . . . . .&nbsp;. . . . . . . . . .&nbsp;. . 
						. . . . . . . .&nbsp;. . . . . . . . . .&nbsp;. . . . . . . . . .&nbsp;. . . . 
						. . . . . .&nbsp;. . . . . . . . . .&nbsp;. . . . . . . . . .&nbsp;. . . . . . 
						. . . .&nbsp;. . . . . . . .</font>
            </li>
			<li>
					<font size="2">Dodatkowe informacje (uwagi) . . . . . . . . . . . . . . . . . . . . 
						. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
						. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
						. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
						. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
						. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
						. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
						. . . . . . . . . . </font>
			<li>
					<font size="2">Wystawienie zaświadczenia niezgodnego z prawdą pociąga za sobą 
						odpowiedzialność przewidzianą w odpowiednich przepisach prawa.</font>
			</li>
			</ol>
			<p>
				<table id="Table2" cellspacing="0" width="100%">
					<tbody>
						<tr>
							<td valign="top" align="center" width="33%">
								<font size="1">. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br/>
									miejscowość i data wystawienia</font>
							</td>
							<td valign="top" align="center" width="33%">
								<font size="1"><font size="1">. . . . . . . . . . . . . . . . . . . . . . . . . . . . . 
										.<br/>
										Pieczątka służbowa, nazwisko i imię oraz podpis<br/>
										kierownika komórki finansowej<br/>
										albo upoważnionego pracownika</font></font>
							</td>
							<td valign="top" align="center">
                                <blockquote dir="ltr" style="margin-right: 0px">
                                    <p>
								<font size="1">. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .<br/>
									Pieczątka służbowa, nazwisko i imię<br/>
									oraz podpis pracodawcy - płatnika składek<br/>
									albo upoważnionego pracownika</font>
                                    </p>
                                </blockquote>
							</td>
						</tr>
					</tbody>
				</table>
			</p>
			<p>
                <span style="font-size: 9pt">* niepotrzebne skreślić.<br />
                    1) podać, jeżeli płatnikowi – pracodawcy jest znany numer PESEL.
                    <br />
                    2) wymiar czasu pracy – podać w przypadku zatrudnienia wykonywanego przed 15.11.1991
                    r.
                    <br />
                    3) wynagrodzenie za czas niezdolności do pracy wypłacone po dniu 28.02.1995 r. na
                    podstawie art. 92 Kodeksu pracy (lub innych przepisów).
                    <br />
                    4) jeżeli po dniu 14.11.1991 r. były wielokrotnie wypłacane zasiłki chorobowe i
                    opiekuńcze oraz po dniu 28.02.1995 r. wynagrodzenie za czas niezdolności do pracy
                    – 4) należy dołączyć wykaz okresów, za które zostały wypłacone te zasiłki; wykaz
                    ten stanowi integralną część zaświadczenia o zatrudnieniu i wynagrodzeniu. </span>
			</p>
            <p>
                <span style="font-size: 10pt">Załączniki: . . . . . . . . . . . . . .</span></p>
            <p style="text-align: center">
                <span style="font-size: 10pt"><strong>INFORMACJA</strong> </span>
            </p>
            <p>
                <span style="font-size: 9pt"><strong>1.</strong> Zasady ustalania podstawy wymiaru emerytur i rent określają
                    przepisy ustawy z 17.12.1998 r. o emeryturach i rentach z Funduszu Ubezpieczeń Społecznych
                    (Dz.U. z 2013 r., poz. 1440 ze zm.) oraz przepisy ustawy z dnia 30.10.2002 r.
                    o ubezpieczeniu społecznym z tytułu wypadków przy pracy i chorób zawodowych (Dz.U.
                    z 2009 r. Nr 167, poz. 1322) a także przepisy rozporządzenia Rady Ministrów z
                    1.04.1985 r. w sprawie szczegółowych zasad ustalania podstawy wymiaru emerytur i
                    rent (Dz.U. z 1989 r. Nr 11, poz. 63 ze zm.) – jeżeli nie są sprzeczne z przepisami
                    ustawy o emeryturach i rentach z FUS.
                    <br />
                </span><span style="font-size: 9pt"><strong>2.</strong> Dokumentem potwierdzającym wysokość wynagrodzeń
                    jest przede wszystkim zaświadczenie o zatrudnieniu i wynagro- dzeniu wystawione przez
                    pracodawcę (albo prawnego następcę pracodawcy, syndyka bądź likwidatora) na druku:
                    ZUS Rp-7.<br />
                </span><span style="font-size: 9pt"><strong>3.</strong> Podstawę wymiaru emerytury i
                    renty stanowi przeciętna podstawa wymiaru składek na ubezpieczenie społeczne – do
                    31.12.1998 r., a także na ubezpieczenia emerytalne i rentowe – od 1.01.1999 r. W
                    zaświadczeniu należy wykazać wynagrodzenie (przychód) uzyskiwane w okresie trwania
                    stosunku pracy, od którego istniał obowiązek opłacania składek na ubezpieczenie
                    społeczne lub ubezpieczenia emerytalne i rentowe.
                    <br />
                </span><span style="font-size: 9pt"><strong>4.</strong> Podstawę wymiaru renty z ubezpieczenia wypadkowego stanowi przeciętna podstawa
                    wymiaru składek na ubezpieczenie społeczne – do 31.12.1998 r., a także na ubezpieczenie
                    wypadkowe – od 1.01.1999 r., bez stosowania ograniczenia wynikającego z art. 19
                    ust. 1 ustawy z dnia 13.10.1998 r. o systemie ubezpieczeń społecznych (Dz.U. z 2009 r.
                    Nr 205, poz. 1585 ze zm.). W zaświadczeniu należy wykazać wynagrodzenie (przychód) uzyskiwane
                    w okresie trwania stosunku pracy, od którego istniał obowiązek opłacania składek
                    na ubezpieczenie społeczne lub ubezpieczenie wypadkowe.<br />
                </span><span style="font-size: 9pt"><strong>
                    5.</strong> Wartość świadczeń w naturze dolicza się w kwotach stanowiących podstawę wymiaru
                    składek na ubezpieczenie społeczne lub ubezpieczenia emerytalne i rentowe albo ubezpieczenie
                    wypadkowe.<br />
                </span><span style="font-size: 9pt"><strong>
                    6.</strong> Do podstawy wymiaru emerytury, renty w tym także do renty z ubezpieczenia wypadkowego
                    lub kapitału początkowego dolicza się przysługujące pracownikowi w danym roku kalendarzowym:
                    kwoty wynagrodzeń za czas niezdolności do pracy wypłacone na podstawie art. 92 Kodeksu
                    pracy (lub innych przepisów w tym zakresie), kwoty zasiłków: chorobowego, macierzyńskiego,
                    opiekuńczego, świadczenia rehabilitacyjnego, zasiłku wyrównawczego, świadczenia
                    wyrównawczego lub dodatku wyrównawczego, wartość rekompensaty pieniężnej ustalonej
                    z tytułu okresowego niepodwyższania płac w sferze budżetowej.<br />
                    Przy ustalaniu podstawy wymiaru emerytury lub renty uwzględnia się kwoty wynagrodzeń
                    za czas niezdolności do pracy, oraz kwoty zasiłków: chorobowego, macierzyńskiego,
                    opiekuńczego, przysługujących ubezpieczonemu w roku kalendarzowym przypadającym
                    po 2004 r., z tym że łączna kwota podstaw wymiaru składek na ubezpieczenie emerytalne
                    i rentowe oraz wynagrodzeń i zasiłków nie może przekroczyć maksymalnej kwoty rocznej
                    podstawy wymiaru składek na ubezpieczenie emerytalne i rentowe.<br />
                </span>
                <p><span style="font-size: 10pt"><strong>ZUS Rp-7</strong></span></p>
            </p>
            <br /><br /><br /><br /><br /><br />
            <ea:PageBreak id="PageBreak4" runat="server"></ea:PageBreak>
            <p>
                <span style="font-size: 9pt"><strong>
                    7.</strong> Wynagrodzenie (lub jego składniki) stanowiące podstawę wymiaru składek, wypłacone
                    po upływie danego roku, należy doliczyć do wynagrodzenia za rok, za który przysługują.
                    W przypadku, gdy nie jest możliwe ustalenie okresu, za jaki przysługuje dana wypłata,
                    dolicza się ją do roku, w którym została wypłacona (np. premia bilansowa, nagroda
                    za osiągnięcia zawodowe).<br />
                </span><span style="font-size: 9pt"><strong>
                    8.</strong> Podstawę wymiaru <strong><em>kapitału początkowego</em></strong> stanowi przeciętna
                    podstawa wymiaru składek na ubezpieczenie społeczne do 31 grudnia 1998 r. </span><br />
                <span>
                    <span style="font-size: 9pt"><strong>9.</strong> W
                    pkt. 3 zaświadczenia należy wykazać:<br />
                        <em>— w kolumnie 2</em> – łączną kwotę stałych składników wynagrodzenia – przychodu (dochodu
                    do 31.12.1998 r.) – uposażenia, np. wynagrodzenie zasadnicze, dodatek za wysługę
                    lat, funkcyjny, służbowy, za pracę wykonywaną w warunkach szkodliwych lub niebezpiecznych
                    dla zdrowia,<br />
                        <em>— w kolumnie 3</em> – łączną kwotę zmiennych lub uznaniowych składników wynagrodzenia,
                    np.: premie regulaminowe, z zysku, eksportowe, nagrody za osiągnięcia zawodowe,
                    dydaktyczno-wychowawcze dla nauczycieli, „trzynastki”, wynagrodzenie za pracę w
                    godzinach nadliczbowych, oraz rodzaj składnika wynagrodzenia, np. premia regulaminowa,
                    nagroda z zakładowego funduszu nagród,
                    <br />
                        <em>— w kolumnie 4</em> – łączną kwotę innych wypłat, np. rekompensaty pieniężne wypłacone
                    pracownikowi obok wynagrodzenia lub zasiłku z ubezpieczenia społecznego, honoraria
                    wypłacane dziennikarzom za pracę dziennikarską przez macierzystą redakcję oraz pracownikom
                    własnym za prace związane z przygotowaniem, organizacją i realizacją programu radiowego
                    i telewizyjnego, wartość rekompensaty pieniężnej ustalonej z tytułu okresowego niepodwyższania
                    płac w sferze budżetowej oraz rodzaj wypłaty,<br />
                        <em>
                    — w kolumnie 5</em> – łączną kwotę równowartości świadczeń w naturze i ekwiwalentu za
                    te świadczenia, oraz rodzaj świadczenia,<br />
                        <em>
                    — w kolumnie 6</em> – łączną kwotę świadczeń pieniężnych z ubezpieczenia społecznego
                    wypłaconych zamiast wynagrodzenia: zasiłek chorobowy, macierzyński, opiekuńczy,
                    wyrównawczy, dodatek wyrównawczy, świadczenie wyrównawcze i rehabilitacyjne oraz
                    wynagrodzenie za czas niezdolności do pracy wypłacone przez pracodawcę na podstawie
                    art. 92 Kodeksu pracy (lub innych przepisów w tym zakresie),<br />
                        <em>
                    — w kolumnie 7</em> – łączną kwotę wszystkich składników wynagrodzenia – przychodu –
                    świadczeń pieniężnych z ubezpieczenia społecznego – uposażenia, o ile od zasiłku
                    macierzyńskiego została opłacona składka na ubezpieczenia emerytalne i rentowe –
                    zasiłek ten należy wykazać w kolumnie 4.<br />
                    W razie wątpliwości, czy dany składnik podlega wliczeniu do podstawy wymiaru, pracodawca
                    nie powinien wykazywać go w tabeli zamieszczonej w pkt. 3 zaświadczenia, lecz podać
                    w pkt. 6, kwotę, datę wypłaty, tytuł wypłaty i okres.<br />
                    Roczną podstawę wymiaru składek wynoszącą od dnia 1.01.1999 r. 30-krotność prognozowanego
                    przeciętnego wynagrodzenia – należy wykazać w kolumnie 2 z komentarzem „limit” podając
                    także miesiąc, w którym nastąpiło przekroczenie tego limitu.<br />
                    Jeżeli za rok, w którym osiągnięto „limit”, zostały dokonane wypłaty (np. „trzynastej
                    pensji”) – dolicza się je do roku, za który przysługują, o ile w roku wypłaty stanowiły
                    one podstawę wymiaru składek. Doliczenie takie powoduje jednak wyłączenie tych wypłat
                    z limitu za rok, w którym je wypłacono. Przykład: ubezpieczony w 1999 r. i 2000
                    r. osiągnął limit obowiązujący w tych latach. Do podstawy wymiaru za dany rok uwzględnia
                    się kwotę rocznej podstawy wymiaru składek oraz np. „trzynastkę” za 1999 r. (wypłaconą
                    w 2000 r.) a za 2000 r. (wypłaconą w 2001 r.), o ile w 2000 r. i 2001 r. „trzynastka”
                    stanowiła podstawę wymiaru składek. Doliczenie tych „trzynastek” powoduje jednak
                    konieczność zmniejszenia limitu z 2000 r. o „trzynastkę” za 1999 r. i limitu z 2001
                    r. o „trzynastkę” za rok 2000.<br />
                        <strong>
                    10.</strong> Za rok, w którym osiągnięto „limit” podstawy wymiaru składek na ubezpieczenia
                    emerytalne i rentowe, w kolumnie 4 należy wykazywać wynagrodzenie stanowiące podstawę
                    wymiaru składek na ubezpieczenie wypadkowe wypłacone ponad „limit” z opisem „ubezpieczenie
                    wypadkowe”. Wynagrodzenie pracownika (kolumny 2-7) powinno być podawane w jednostkach
                    pieniężnych obowiązujących w okresie, z którego są wykazywane. W przypadku wątpliwości,
                    o bliższe wyjaśnienia w sprawie sposobu ustalania podstawy wymiaru, należy zwrócić
                    się do oddziału (inspektoratu) ZUS.</span></span></p>
            <p><span style="font-size: 10pt"><strong>ZUS Rp-7</strong></span></p>
            <p>
				<cc1:ReportFooter id="ReportFooter2" runat="server" TheEnd="False"></cc1:ReportFooter>
            </p>
            <ea:PageBreak id="PageBreak3" runat="server"></ea:PageBreak>
			<cc1:reportheader id="ReportHeader2" 
                title="ZAŁĄCZNIK DO ZAŚWIADCZENIA O ZATRUDNIENIU I WYNAGRODZENIU|Zestawienie wynagrodzeń/zasiłków pobranych za okresy niezdolności do pracy.|&lt;/strong&gt;%PŁEĆ%: &lt;strong&gt; {0}" 
                runat="server" DataMember0="Pracownik.ImięNazwisko"></cc1:reportheader>
            <p>            
			<ea:Grid id="Grid2" runat="server" GroupData0="Kategoria" GroupLine="{0}">
				<Columns>
					<ea:GridColumn ID="GridColumn8" Caption="Nieobecność" runat="server" DataMember="Nazwa"></ea:GridColumn>
					<ea:GridColumn ID="GridColumn9" runat="server" Caption="Od dnia" DataMember="Okres.From" 
                        Align="Center" Width="20">
                    </ea:GridColumn>
                    <ea:GridColumn ID="GridColumn10" runat="server" Caption="Do dnia" DataMember="Okres.To" 
                        Align="Center" Width="20">
                    </ea:GridColumn>
				</Columns>
			</ea:Grid>
            </p>			
            <p><span style="font-size: 10pt"><strong>ZUS Rp-7</strong></span></p>
            <p>
				<cc1:ReportFooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:ReportFooter>
            </p>
		</form>
	</body>
</HTML>

